IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_TBL_ATUALIZACAO_GRUPO_PRECOS]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_TBL_ATUALIZACAO_GRUPO_PRECOS]
GO 

--EXECUTE P_EST_PROD_PRECO_TBL_ATUALIZACAO_GRUPO_PRECOS 2,6
CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_TBL_ATUALIZACAO_GRUPO_PRECOS] (@CD_CTR_GRP  INT,
                                                                       @CD_CTR_PROC INT)
AS
  BEGIN
      DECLARE @CD_EMP INT
      DECLARE @CD_CTR INT
      DECLARE @FLAG_IGNORAR_BLISTERS INT
      DECLARE @FLAG_NAO_ATUALIZAR_PRECO_OFERTA INT
      DECLARE @CD_PROD INT
      DECLARE @VLR_FORNC MONEY
      DECLARE @VLR_VENDA MONEY
      DECLARE @CD_USU INT
      DECLARE @CVLR_VD VARCHAR(50)
      DECLARE @CVLR_FORN VARCHAR(50)
      DECLARE @DT_REF DATETIME
      DECLARE @PERC_ICMS MONEY
      DECLARE @FLAG_EXCECAO INT
	  DECLARE @ZONA_FRANCA INT -- VERIFICA SE O GRUPO TEM ZONA FRANCA
      DECLARE @TIPO_EXCECAO INT -- VERIFICA SE NO GRUPO DE PRECO HA EXCECAO DE ALIQUOTA (0 - SEM EXCESSAO , 1 - GENERICO, 2 - ETICO, 3 - SIMILAR)
      DECLARE @PERC_ICMS_EXCECAO MONEY -- PERCENTUAL DA ALIQUOTA DE EXCECAO
      SET @DT_REF = CONVERT(DATETIME, CONVERT(VARCHAR, GETDATE(), 112));
		 --DEBUG
		 --DECLARE @CD_CTR_GRP INT 
		 --DECLARE @CD_CTR_PROC INT
		 --SET @CD_CTR_PROC = 1
		 --SET @CD_CTR_GRP = 4
		 --DROP TABLE #RS_EST_PROD_PRECO_TBL
		 --DROP TABLE #RS_EST_PROD_PRECO_TBL_BLISTERS
		 --DROP TABLE #RSPRECOATU
      --DELETANDO PRECOS QUE NAO POSSUI GRUPO 
      DELETE FROM EST_PROD_PRECO_TBL
      WHERE  CD_CTR_GRP = 0
	  DELETE
	  FROM
		EST_PROD_PRECO_TBL_HIST_CPL
	  WHERE
	    ISNUMERIC(PERC_ICMS)=0
      --BUSCANDO VARIAVEIS DE CONTROLE PARA INICIO DA ATUALIZA??O
      --DE ACORDO COM O GRUPO DE PRECOS E A CARGA AGENDADA
      SELECT TOP 1
        @CD_EMP = CD_EMP
        ,@CD_CTR = CD_CTR
        ,@FLAG_IGNORAR_BLISTERS = ISNULL(FLAG_IGNORAR_BLISTERS, 0)
        ,@FLAG_NAO_ATUALIZAR_PRECO_OFERTA = ISNULL(FLAG_NAO_ATUALIZAR_PRECO_OFERTA, 0)
      FROM   EST_PROD_PRECO_TBL_HIST
      WHERE  DT_PROCESSAR <= @DT_REF
             AND FLAG_PROCESSADO = 0
             AND CD_CTR_GRP = @CD_CTR_GRP
             AND CD_CTR = @CD_CTR_PROC;
      PRINT 'PROCESSAR CONTROLE PRECOS: '+ CAST(@CD_CTR AS VARCHAR(10));
      SET @PERC_ICMS = ISNULL((SELECT
                                      PERC_ICMS
                                    FROM   EST_PROD_PRECO_TBL_GRUPO
                                    WHERE  CD_CTR_GRP =@CD_CTR_GRP ), 0)
      SET @FLAG_EXCECAO = (SELECT 
							 CASE  
							 WHEN ORIG_ARQ = 4 THEN 0
							 ELSE (SELECT
										  isnull(FLAG_EXCECAO,0)
										FROM   EST_PROD_PRECO_TBL_GRUPO
										WHERE  CD_CTR_GRP = @CD_CTR_GRP)
							 END
							  FROM   EST_PROD_PRECO_TBL_HIST
							   WHERE  
									 CD_CTR_GRP = @CD_CTR_GRP
									AND CD_CTR =  @CD_CTR_PROC )

									PRINT '@FLAG_EXCECAO: '+ CAST(@FLAG_EXCECAO AS VARCHAR(2));
     SET @ZONA_FRANCA = ISNULL((SELECT
                                    ZONA_FRANCA
                                  FROM   EST_PROD_PRECO_TBL_GRUPO
                                  WHERE  CD_CTR_GRP = @CD_CTR_GRP), 0) 
      IF @FLAG_EXCECAO > 0
        BEGIN
            SET @TIPO_EXCECAO = (SELECT
                                   TIPO_EXCECAO
                                 FROM   EST_PROD_PRECO_TBL_GRUPO
                                 WHERE  CD_CTR_GRP = @CD_CTR_GRP)
            SET @PERC_ICMS_EXCECAO = ISNULL((SELECT
                                                    PERC_EXCECAO
                                                  FROM   EST_PROD_PRECO_TBL_GRUPO
                                                  WHERE  CD_CTR_GRP = @CD_CTR_GRP), 0) 
        END
	   --DEBUG
	   --SELECT @CD_CTR AS CD_CTR , @CD_CTR_GRP AS CD_CTR_GRP, @PERC_ICMS AS PERC_ICMS, @FLAG_EXCECAO AS FLAG_EXCECAO, @PERC_ICMS_EXCECAO AS PERC_ICMS_EXCECAO , @FLAG_EXCECAO AS FLAG_EXCECAO ,  @TIPO_EXCECAO AS  TIPO_EXCECAO , @PERC_ICMS_EXCECAO AS PERC_ICMS_EXCECAO, @ZONA_FRANCA AS ZONA_FRANCA
	  --CRIANDO A TABELA #RS_EST_PROD_PRECO_TBL
      CREATE TABLE #RS_EST_PROD_PRECO_TBL
        (
           CD_EMP   INT,
           CD_PROD  INT,
           VLR_FORN MONEY,
           VLR_VD   MONEY,
           CD_USU   INT
        )
      --CRIANDO A TABELA #RS_EST_PROD_PRECO_TBL_BLISTERS
      CREATE TABLE #RS_EST_PROD_PRECO_TBL_BLISTERS
        (
           CD_EMP   INT,
           CD_PROD  INT,
           VLR_FORN MONEY,
           VLR_VD   MONEY,
           CD_USU   INT
        )
      --CRIANDO TABELA TEMPORARIA DE CARGA DE PRE?OS POR GRUPO DE PRE?OS
      CREATE TABLE #RSPRECOATU
        (
           CD_EMP     INT,
           CD_FILIAL  INT,
           CD_CTR_GRP INT,
           CD_CTR     INT,
           CD_PROD    INT,
           VLR_FORN   MONEY,
           VLR_VD     MONEY,
           CD_USU     INT,
           PERC_ICMS  MONEY,
           EXCECAO    INT  
        )
	CREATE UNIQUE CLUSTERED INDEX ix_#rsprecoatu ON 
	   #rsprecoatu (CD_PROD,CD_FILIAL,CD_EMP);		
      --INSERINDO DADOS DOS NOVOS PREcOS DE 
	 -- ACORDO COM A CARGA NOVA DE PRE?OS
	 --EXCESSOES
	   IF @FLAG_EXCECAO > 0
	   BEGIN
		  INSERT INTO #RSPRECOATU
		  SELECT
			 EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP
			 ,EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_FILIAL
			 ,EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP
			 ,EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR
			 ,EST_PROD_PRECO_TBL_HIST_CPL.CD_PROD
			 ,EST_PROD_PRECO_TBL_HIST_CPL.VLR_FORN
			 ,EST_PROD_PRECO_TBL_HIST_CPL.VLR_VD
			 ,EST_PROD_PRECO_TBL_HIST.CD_USU
			 ,EST_PROD_PRECO_TBL_HIST_CPL.PERC_ICMS
			 ,1
		  FROM   
			 EST_PROD_PRECO_TBL_HIST_CPL
			 INNER JOIN EST_PROD_PRECO_TBL_HIST
			 ON EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP = EST_PROD_PRECO_TBL_HIST.CD_EMP
			 AND EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR = EST_PROD_PRECO_TBL_HIST.CD_CTR
			 INNER JOIN EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL
			 ON EST_PROD_PRECO_TBL_HIST.CD_EMP = EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_EMP
			 AND EST_PROD_PRECO_TBL_HIST.CD_CTR_GRP = EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP
			 INNER JOIN EST_PROD_PRECO_TBL_GRUPO ON 
			 EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP = EST_PROD_PRECO_TBL_GRUPO.CD_CTR_GRP AND 
			 EST_PROD_PRECO_TBL_HIST_CPL.PERC_ICMS = EST_PROD_PRECO_TBL_GRUPO.PERC_EXCECAO 
			 INNER JOIN EST_PROD B ON 
			 EST_PROD_PRECO_TBL_HIST_CPL.CD_PROD = B.CD_PROD
		  WHERE  
			 EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP = @CD_EMP
			 AND EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR = @CD_CTR
			 AND EST_PROD_PRECO_TBL_HIST.DT_PROCESSAR <= @DT_REF
			 AND EST_PROD_PRECO_TBL_HIST.FLAG_PROCESSADO = 0
			 AND EST_PROD_PRECO_TBL_GRUPO.FLAG_EXCECAO=1 
			 AND EST_PROD_PRECO_TBL_HIST_CPL.ZONA_FRANCA = @ZONA_FRANCA
		      AND  CASE
                     WHEN @TIPO_EXCECAO = 1 THEN B.FLAG_PRODUTO_GENERICO
                     WHEN @TIPO_EXCECAO = 2 THEN B.FLAG_PRODUTO_ETICO
                     ELSE B.FLAG_PRODUTO_SIMILAR
                   END = 1
                   AND EST_PROD_PRECO_TBL_HIST_CPL.PERC_ICMS = @PERC_ICMS_EXCECAO
	   end
      --INSERINDO DADOS DOS NOVOS PRE?OS DE ACORDO COM A CARGA NOVA DE PRE?OS
      INSERT INTO #RSPRECOATU
      SELECT
        EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP
        ,EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_FILIAL
        ,EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP
        ,EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR
        ,EST_PROD_PRECO_TBL_HIST_CPL.CD_PROD
        ,EST_PROD_PRECO_TBL_HIST_CPL.VLR_FORN
        ,EST_PROD_PRECO_TBL_HIST_CPL.VLR_VD
        ,EST_PROD_PRECO_TBL_HIST.CD_USU
        ,EST_PROD_PRECO_TBL_HIST_CPL.PERC_ICMS
        ,0
      FROM   EST_PROD_PRECO_TBL_HIST_CPL
		  INNER JOIN EST_PROD_PRECO_TBL_HIST
		  ON EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP = EST_PROD_PRECO_TBL_HIST.CD_EMP
		  AND EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR = EST_PROD_PRECO_TBL_HIST.CD_CTR
		  INNER JOIN EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL
		  ON EST_PROD_PRECO_TBL_HIST.CD_EMP = EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_EMP
		  AND EST_PROD_PRECO_TBL_HIST.CD_CTR_GRP = EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP
		  INNER JOIN EST_PROD_PRECO_TBL_GRUPO
		  ON EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP = EST_PROD_PRECO_TBL_GRUPO.CD_CTR_GRP
		  AND EST_PROD_PRECO_TBL_HIST_CPL.PERC_ICMS = EST_PROD_PRECO_TBL_GRUPO.PERC_ICMS
		  LEFT JOIN #RSPRECOATU a on 
		  EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP			= A.CD_EMP AND 
		  EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_FILIAL	= A.CD_FILIAL AND 		  
		  EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL.CD_CTR_GRP	= A.CD_CTR_GRP AND 
		  EST_PROD_PRECO_TBL_HIST_CPL.CD_PROD			= A.CD_PROD 
      WHERE  
		  EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP = @CD_EMP
		  AND EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR = @CD_CTR
		  AND EST_PROD_PRECO_TBL_HIST.DT_PROCESSAR <= @DT_REF
		  AND EST_PROD_PRECO_TBL_HIST.FLAG_PROCESSADO = 0
		  AND EST_PROD_PRECO_TBL_HIST_CPL.ZONA_FRANCA = @ZONA_FRANCA
		  AND A.CD_EMP IS NULL
      PRINT 'CARREGOU TABELA AUXILIAR #RSPRECOATU' 
     --DEBUG 
	 --SELECT * FROM #RSPRECOATU WHERE EXCECAO = 1 order by cd_prod
	 --SELECT * FROM #RSPRECOATU WHERE EXCECAO = 0 order by cd_prod
      ----------------INICIA O PROCESSO DE ATUALIZACAO DE PRECOS
      --TODOS OS PRODUTOS
      IF @FLAG_IGNORAR_BLISTERS = 0
        BEGIN
            PRINT 'IF @FLAG_IGNORAR_BLISTERS = 0';
            --ALTERANDO VALORES DE TABELA DE VENDAS
            UPDATE P
            SET    P.VLR_TABELA = N.VLR_VD,
                   P.VLR_OFERTA = CASE
                                    WHEN @FLAG_NAO_ATUALIZAR_PRECO_OFERTA = 0 THEN 0
                                    ELSE P.VLR_OFERTA
                                  END,
                   P.DT_CAD = @DT_REF,
                   P.CD_USU = N.CD_USU
			--select *
            FROM   #RSPRECOATU N
                   INNER JOIN EST_PROD_PRECO P
                           ON N.CD_EMP = P.CD_EMP
                              AND N.CD_FILIAL = P.CD_FILIAL
                              AND N.CD_PROD = P.CD_PROD
                              AND N.PERC_ICMS = CASE
                                                  WHEN N.EXCECAO  = 0 THEN @PERC_ICMS
                                                  ELSE @PERC_ICMS_EXCECAO
                                                END
            PRINT 'ATUALIZOU EST_PROD_PRECO'
            --INSERINDO NA TABELA DE PRECO_TBL	
            INSERT INTO #RS_EST_PROD_PRECO_TBL
            SELECT DISTINCT
              CPL.CD_EMP
              ,CPL.CD_PROD
              ,CPL.VLR_FORN
              ,CPL.VLR_VD
              ,H.CD_USU
            FROM   #RSPRECOATU CPL
                   INNER JOIN EST_PROD_PRECO_TBL_HIST H
                           ON CPL.CD_EMP = H.CD_EMP
                              AND CPL.CD_CTR = H.CD_CTR
            WHERE  CPL.CD_EMP = @CD_EMP
                   AND CPL.CD_CTR = @CD_CTR
                   AND CPL.PERC_ICMS = CASE
                                         WHEN CPL.EXCECAO = 0 THEN @PERC_ICMS
                                         ELSE @PERC_ICMS_EXCECAO
                                       END
            /*AND NOT EXISTS (SELECT 
            CD_PROD 
            FROM 
            EST_PROD_PRECO_TBL 
            WHERE 
            CPL.CD_EMP = CD_EMP AND 
            CPL.CD_PROD = CD_PROD AND
            CPL.CD_CTR_GRP = CD_CTR_GRP)	*/
            SET NOCOUNT ON
            DECLARE PRECO_TBL CURSOR FAST_FORWARD FOR
              SELECT
                CD_EMP
                ,CD_PROD
                ,VLR_FORN
                ,VLR_VD
                ,CD_USU
              FROM   #RS_EST_PROD_PRECO_TBL
            OPEN PRECO_TBL
            FETCH NEXT FROM PRECO_TBL INTO @CD_EMP,
                                           @CD_PROD,
                                           @VLR_FORNC,
                                           @VLR_VENDA,
                                           @CD_USU
            WHILE @@FETCH_STATUS = 0
              BEGIN
                  DELETE FROM EST_PROD_PRECO_TBL
                  WHERE  CD_EMP = @CD_EMP
                         AND CD_PROD = @CD_PROD
                         AND CD_CTR_GRP = @CD_CTR_GRP
                  --PRINT 'CD_PROD =' + CONVERT(VARCHAR,@CD_PROD) + ' AND CD_CTR_GRP = ' + CONVERT(VARCHAR, @CD_CTR_GRP)
                  INSERT INTO EST_PROD_PRECO_TBL
                              (CD_EMP,
                               CD_PROD,
                               VLR_FORN,
                               VLR_VD,
                               CD_USU,
                               DT_CAD,
                               CD_CTR_GRP)
                  VALUES      (@CD_EMP,
                               @CD_PROD,
                               @VLR_FORNC,
                               @VLR_VENDA,
                               @CD_USU,
                               GETDATE(),
                               @CD_CTR_GRP)
                  FETCH NEXT FROM PRECO_TBL INTO @CD_EMP,
                                                 @CD_PROD,
                                                 @VLR_FORNC,
                                                 @VLR_VENDA,
                                                 @CD_USU
              END
            --FECHANDO CURSOS
            CLOSE PRECO_TBL;
            --DESALOCANDO CURSOS DA MEMORIA
            DEALLOCATE PRECO_TBL;
            --APAGANDO A TABELA TEMPORARIA
            DROP TABLE #RS_EST_PROD_PRECO_TBL;
            --ALTERANDO VALORES DO PRECO PMC
            UPDATE P
            SET    P.VLR_FORN = N.VLR_FORN,
                   P.VLR_VD = N.VLR_VD
            FROM   #RSPRECOATU N
                   INNER JOIN EST_PROD_PRECO_TBL P
                           ON N.CD_EMP = P.CD_EMP
                              AND N.CD_PROD = P.CD_PROD
                              AND N.CD_CTR_GRP = P.CD_CTR_GRP
            WHERE  N.PERC_ICMS = CASE
                                         WHEN N.EXCECAO = 0 THEN @PERC_ICMS
                                         ELSE @PERC_ICMS_EXCECAO
                                       END
            PRINT 'FINALIZOU EST_PROD_PRECO_TBL'
        END
      ----IGNORANDO OS PRODUTOS EM BLISTERS
      IF @FLAG_IGNORAR_BLISTERS = 1
        BEGIN
            --ALTERANDO VALORES DE TABELA DE VENDAS
            UPDATE P
            SET    P.VLR_TABELA = N.VLR_VD,
                   P.VLR_OFERTA = CASE
                                    WHEN @FLAG_NAO_ATUALIZAR_PRECO_OFERTA = 0 THEN 0
                                    ELSE P.VLR_OFERTA
                                  END,
                   P.DT_CAD = @DT_REF,
                   P.CD_USU = N.CD_USU
            FROM   #RSPRECOATU N
                   INNER JOIN EST_PROD_PRECO P
                           ON N.CD_EMP = P.CD_EMP
                              AND N.CD_FILIAL = P.CD_FILIAL
                              AND N.CD_PROD = P.CD_PROD
                              AND N.PERC_ICMS = CASE
                                         WHEN N.EXCECAO = 0 THEN @PERC_ICMS
                                         ELSE @PERC_ICMS_EXCECAO
                                       END
                   INNER JOIN EST_PROD C
                           ON N.CD_EMP = C.CD_EMP
                              AND N.CD_PROD = C.CD_PROD
            WHERE  N.CD_EMP = @CD_EMP
                   AND N.CD_CTR = @CD_CTR
                   AND C.FLAG_PRODUTO_BLISTER <> 1;
            PRINT 'ATUALIZOU EST_PROD_PRECO'
            --INSERINDO NA TABELA DE PRECO_TBL	
            INSERT INTO #RS_EST_PROD_PRECO_TBL_BLISTERS
            SELECT DISTINCT
              CPL.CD_EMP
              ,CPL.CD_PROD
              ,CPL.VLR_FORN
              ,CPL.VLR_VD
              ,H.CD_USU
            FROM   #RSPRECOATU CPL
                   INNER JOIN EST_PROD_PRECO_TBL_HIST H
                           ON CPL.CD_EMP = H.CD_EMP
                              AND CPL.CD_CTR = H.CD_CTR
                   INNER JOIN EST_PROD P
                           ON CPL.CD_EMP = P.CD_EMP
                              AND CPL.CD_PROD = P.CD_PROD
            WHERE  CPL.CD_EMP = @CD_EMP
                   AND CPL.CD_CTR = @CD_CTR
                   AND P.FLAG_PRODUTO_BLISTER <> 1
                   AND CPL.PERC_ICMS =  CASE
                                         WHEN CPL.EXCECAO = 0 THEN @PERC_ICMS
                                         ELSE @PERC_ICMS_EXCECAO
                                       END
            /*AND NOT EXISTS (SELECT 
            CD_PROD 
            FROM 
            EST_PROD_PRECO_TBL 
            WHERE 
            CPL.CD_EMP = CD_EMP AND 
            CPL.CD_PROD = CD_PROD AND
            CPL.CD_CTR_GRP = CD_CTR_GRP)	*/
            SET NOCOUNT ON
            DECLARE PRECO_TBL CURSOR FAST_FORWARD FOR
              SELECT
                CD_EMP
                ,CD_PROD
                ,VLR_FORN
                ,VLR_VD
                ,CD_USU
              FROM   #RS_EST_PROD_PRECO_TBL_BLISTERS
            OPEN PRECO_TBL
            FETCH NEXT FROM PRECO_TBL INTO @CD_EMP,
                                           @CD_PROD,
                                           @VLR_FORNC,
                                           @VLR_VENDA,
                                           @CD_USU
            WHILE @@FETCH_STATUS = 0
              BEGIN
                  DELETE FROM EST_PROD_PRECO_TBL
                  WHERE  CD_EMP = @CD_EMP
                         AND CD_PROD = @CD_PROD
                         AND CD_CTR_GRP = @CD_CTR_GRP
                  --PRINT 'CD_PROD =' + CONVERT(VARCHAR,@CD_PROD) + ' AND CD_CTR_GRP = ' + CONVERT(VARCHAR, @CD_CTR_GRP)
                  INSERT INTO EST_PROD_PRECO_TBL
                              (CD_EMP,
                               CD_PROD,
                               VLR_FORN,
                               VLR_VD,
                               CD_USU,
                               DT_CAD,
                               CD_CTR_GRP)
                  VALUES      (@CD_EMP,
                               @CD_PROD,
                               @VLR_FORNC,
                               @VLR_VENDA,
                               @CD_USU,
                               GETDATE(),
                               @CD_CTR_GRP)
                  PRINT 'INSERIU EST_PROD_PRECO_TBL'
                  FETCH NEXT FROM PRECO_TBL INTO @CD_EMP,
                                                 @CD_PROD,
                                                 @VLR_FORNC,
                                                 @VLR_VENDA,
                                                 @CD_USU
              END
            --FECHANDO CURSOS
            CLOSE PRECO_TBL;
            --DESALOCANDO CURSOS DA MEMORIA
            DEALLOCATE PRECO_TBL;
            --APAGANDO A TABELA TEMPORARIA
            DROP TABLE #RS_EST_PROD_PRECO_TBL_BLISTERS;
            --ALTERANDO VALORES DO PRECO PMC	
            UPDATE P
            SET    P.VLR_FORN = N.VLR_FORN,
                   P.VLR_VD = N.VLR_VD
            FROM   #RSPRECOATU N
                   INNER JOIN EST_PROD_PRECO_TBL P
                           ON N.CD_EMP = P.CD_EMP
                              AND N.CD_PROD = P.CD_PROD
                              AND N.CD_CTR_GRP = P.CD_CTR_GRP
                   INNER JOIN EST_PROD C
                           ON N.CD_EMP = C.CD_EMP
                              AND N.CD_PROD = C.CD_PROD
            WHERE  N.CD_EMP = @CD_EMP
                   AND N.PERC_ICMS =  CASE
                                         WHEN N.EXCECAO = 0 THEN @PERC_ICMS
                                         ELSE @PERC_ICMS_EXCECAO
                                       END
                   AND N.CD_CTR = @CD_CTR
                   AND C.FLAG_PRODUTO_BLISTER <> 1;
        END
      --MARCANDO COMO PROCESSADO O LOTE DE 
      --ATUALIZA??O DE PRE?OS
      UPDATE EST_PROD_PRECO_TBL_HIST
      SET    FLAG_PROCESSADO = 1
      WHERE  CD_EMP = @CD_EMP
             AND CD_CTR = @CD_CTR
      PRINT 'ATUALIZOU O AGENDAMENTO '
            + CONVERT(VARCHAR, @CD_CTR)

      PRINT 'ATUALIZANDO CD_TISS DA EST_PROD '
            + CONVERT(VARCHAR, @CD_CTR)
	   UPDATE EST_PROD SET EST_PROD.CD_TISS = EST_PROD_PRECO_TBL_HIST_CPL.CD_TISS 
	   FROM EST_PROD INNER JOIN EST_PROD_PRECO_TBL_HIST_CPL ON
	   EST_PROD.CD_EMP = EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP 
	   AND EST_PROD.CD_PROD = EST_PROD_PRECO_TBL_HIST_CPL.CD_PROD
	   WHERE EST_PROD_PRECO_TBL_HIST_CPL.CD_TISS > 0 
	   AND ISNULL(EST_PROD.CD_TISS,0) <> ISNULL(EST_PROD_PRECO_TBL_HIST_CPL.CD_TISS,0)
	   AND EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR = @CD_CTR
  END

GO


